#!/bin/sh

# If no argument is passed then do not add a suffix to the service or the generated docker-compose file
SERVICE_TYPE_SUFFIX=${1:-""}

# app.env must be sourced prior to executing this script
printf "\n\n\n\n**** Generating docker-compose${SERVICE_TYPE_SUFFIX}.yml ********************\n\n"

# Generate docker-compose-beta.yml from template
/usr/bin/perl -pe "s|%%SERVICE_NAME%%|${SERVICE_NAME}${SERVICE_TYPE_SUFFIX}|" nextgen/docker-compose-template.txt | 
  /usr/bin/perl -pe "s|%%DOCKER_CONTAINER_NAME%%|${DOCKER_CONTAINER_NAME}${SERVICE_TYPE_SUFFIX}|" | 
  /usr/bin/perl -pe "s|%%DOCKER_HOSTNAME%%|${DOCKER_HOSTNAME}${SERVICE_TYPE_SUFFIX}|" | 
  /usr/bin/perl -pe "s|%%DOCKER_IMAGE_NAME%%|${DOCKER_IMAGE_NAME}|" | 
  /usr/bin/perl -pe "s|%%SERVICE_CONFIG_VERSION%%|${SERVICE_CONFIG_VERSION}|" | 
  /usr/bin/perl -pe "s|%%UCP_ACCESS_LABEL%%|${UCP_ACCESS_LABEL}|" > docker-compose${SERVICE_TYPE_SUFFIX}.yml || 
  { echo "FATAL: Could not generate docker-compose${SERVICE_TYPE_SUFFIX}.yml"; exit 1; }
